/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.DoubleMath;

import BryceMath.DoubleMath.Vector;

public class Matrix {
    private double[][] data;
    private final int m;
    private final int n;
    private boolean ge_form = false;
    private boolean ge1_form = false;
    private boolean echelon_form = false;
    private int rank = -1;

    public Matrix(Vector ... rows) {
        this.m = rows.length;
        this.n = rows[0].length;
        this.data = new double[this.m][this.n];
        int c = 0;
        while (c < this.n) {
            int r = 0;
            while (r < this.m) {
                this.data[r][c] = rows[r].get(c);
                ++r;
            }
            ++c;
        }
    }

    public Matrix(boolean want_cols, Vector ... cols) {
        this.n = cols.length;
        this.m = cols[0].length;
        this.data = new double[this.m][this.n];
        int c = 0;
        while (c < this.n) {
            int r = 0;
            while (r < this.m) {
                this.data[r][c] = cols[c].get(r);
                ++r;
            }
            ++c;
        }
    }

    public Matrix(double[][] data) {
        this.data = data;
        this.m = data.length;
        this.n = data[0].length;
    }

    public Matrix transpose() {
        return new Matrix(this.columns());
    }

    public double det() {
        if (this.m != this.n) {
            throw new Error("ERROR: Determinant only defined for square matrices.");
        }
        Matrix reduced = this.ge();
        double result = 1.0;
        int c = 0;
        while (c < this.n) {
            result *= reduced.get(c, c);
            ++c;
        }
        return result;
    }

    public double trace() {
        if (this.m != this.n) {
            throw new Error("ERROR: Trace only defined for square matrices.");
        }
        double result = 0.0;
        int c = 0;
        while (c < this.n) {
            result += this.get(c, c);
            ++c;
        }
        return result;
    }

    public int getRank() {
        if (this.rank < 0) {
            this.rank = this.ge().rank;
        }
        return this.rank;
    }

    public Matrix inverse() {
        if (this.m != this.n) {
            throw new Error("ERROR: Non-square matrices have no inverse.");
        }
        if (this.det() == 0.0) {
            return null;
        }
        Matrix A = this.appendCol(this.identity(this.m).columns());
        A = A.echelon();
        Vector[] output = new Vector[this.m];
        int c = 0;
        while (c < this.n) {
            output[c] = A.getCol(this.n + c);
            ++c;
        }
        return new Matrix(true, output);
    }

    public Vector solve(Vector b) {
        Matrix A = this.appendCol(b);
        A = A.echelon();
        return A.getCol(this.n);
    }

    public Matrix[] LDU() {
        Matrix D;
        Matrix L = this.identity(this.m);
        Matrix U = this.ge2(L, D = this.identity(this.m));
        if (U == null) {
            throw new Error("ERROR: LDU factorization does not exist.");
        }
        Matrix[] output = new Matrix[]{L, D, U};
        return output;
    }

    public Matrix[] QR() {
        throw new Error("Not yet Implemented.");
    }

    public Matrix mult(Matrix B) {
        Vector[] rows = this.rows();
        Vector[] cols = B.columns();
        double[][] data = new double[this.m][this.n];
        int r = 0;
        while (r < this.m) {
            int c = 0;
            while (c < this.n) {
                data[r][c] = rows[r].dot(cols[c]);
                ++c;
            }
            ++r;
        }
        return new Matrix(data);
    }

    public Matrix echelon() {
        if (this.echelon_form) {
            return this;
        }
        Matrix A = this.ge1();
        Vector[] rows = A.rows();
        int r = this.m - 1;
        while (r > 0) {
            int c = 0;
            boolean found = true;
            while (rows[r].get(c) == 0.0) {
                if (++c != this.n) continue;
                found = false;
                break;
            }
            if (!found) break;
            int r2 = r - 1;
            while (r2 >= 0) {
                rows[r2] = rows[r2].sub(rows[r].mult(rows[r2].get(c)));
                --r2;
            }
            --r;
        }
        Matrix output = new Matrix(rows);
        output.echelon_form = true;
        output.ge1_form = true;
        output.ge_form = true;
        this.rank = A.rank;
        return output;
    }

    public Matrix ge() {
        if (this.ge_form) {
            return this;
        }
        Object[] rows = this.rows();
        int c = 0;
        int rank = 0;
        int r = 0;
        while (r < this.m && c < this.n) {
            int r2 = r + 1;
            boolean pivot_found = true;
            if (rows[r].get(c) == 0.0) {
                pivot_found = false;
                while (r2 < this.m) {
                    if (rows[r2].get(c) != 0.0) {
                        Matrix.swap(rows, r, r2);
                        ++r2;
                        pivot_found = true;
                        break;
                    }
                    ++r2;
                }
            }
            if (!pivot_found) {
                --r;
                ++c;
            } else {
                double pivot = rows[r].get(c);
                ++rank;
                Vector temp = rows[r].div(pivot);
                while (r2 < this.m) {
                    rows[r2] = ((Vector)rows[r2]).sub(temp.mult(((Vector)rows[r2]).get(c)));
                    ++r2;
                }
                ++c;
            }
            ++r;
        }
        Matrix output = new Matrix((Vector[])rows);
        output.ge_form = true;
        output.rank = rank;
        return output;
    }

    public Matrix ge1() {
        if (this.ge1_form) {
            return this;
        }
        Object[] rows = this.rows();
        int c = 0;
        int rank = 0;
        int r = 0;
        while (r < this.m && c < this.n) {
            int r2 = r + 1;
            boolean pivot_found = true;
            if (rows[r].get(c) == 0.0) {
                pivot_found = false;
                while (r2 < this.m) {
                    if (rows[r2].get(c) != 0.0) {
                        Matrix.swap(rows, r, r2);
                        ++r2;
                        pivot_found = true;
                        break;
                    }
                    ++r2;
                }
            }
            if (!pivot_found) {
                --r;
                ++c;
            } else {
                double pivot = rows[r].get(c);
                ++rank;
                Vector temp = rows[r].div(pivot);
                rows[r] = temp;
                while (r2 < this.m) {
                    rows[r2] = ((Vector)rows[r2]).sub(temp.mult(((Vector)rows[r2]).get(c)));
                    ++r2;
                }
                ++c;
            }
            ++r;
        }
        Matrix output = new Matrix((Vector[])rows);
        output.ge1_form = true;
        output.ge_form = true;
        output.rank = rank;
        return output;
    }

    private Matrix ge2(Matrix L, Matrix D) {
        if (this.ge1_form) {
            return this;
        }
        Vector[] rows = this.rows();
        int c = 0;
        int rank = 0;
        int r = 0;
        while (r < this.m && c < this.n) {
            int r2 = r + 1;
            boolean pivot_found = true;
            if (rows[r].get(c) == 0.0) {
                pivot_found = false;
                while (r2 < this.m) {
                    if (rows[r2].get(c) != 0.0) {
                        return null;
                    }
                    ++r2;
                }
            }
            if (!pivot_found) {
                --r;
                ++c;
            } else {
                Vector temp;
                double pivot;
                D.data[r][r] = pivot = rows[r].get(c);
                ++rank;
                rows[r] = temp = rows[r].div(pivot);
                while (r2 < this.m) {
                    L.data[r2][r] = rows[r2].get(c) / pivot;
                    rows[r2] = rows[r2].sub(temp.mult(rows[r2].get(c)));
                    ++r2;
                }
                ++c;
            }
            ++r;
        }
        Matrix output = new Matrix(rows);
        output.ge1_form = true;
        output.ge_form = true;
        output.rank = rank;
        return output;
    }

    public Vector[] columns() {
        Vector[] output = new Vector[this.n];
        int c = 0;
        while (c < this.n) {
            double[] temp = new double[this.m];
            int r = 0;
            while (r < this.m) {
                temp[r] = this.data[r][c];
                ++r;
            }
            output[c] = new Vector(temp);
            ++c;
        }
        return output;
    }

    public Vector[] rows() {
        Vector[] output = new Vector[this.m];
        int r = 0;
        while (r < this.m) {
            double[] temp = new double[this.n];
            int c = 0;
            while (c < this.n) {
                temp[c] = this.data[r][c];
                ++c;
            }
            output[r] = new Vector(temp);
            ++r;
        }
        return output;
    }

    public Vector getRow(int r) {
        double[] output = new double[this.n];
        int c = 0;
        while (c < this.n) {
            output[c] = this.data[r][c];
            ++c;
        }
        return new Vector(output);
    }

    public Vector getCol(int c) {
        double[] output = new double[this.m];
        int r = 0;
        while (r < this.m) {
            output[r] = this.data[r][c];
            ++r;
        }
        return new Vector(output);
    }

    public Matrix appendCol(Vector ... new_c) {
        Vector[] output = new Vector[this.n + new_c.length];
        int c = 0;
        while (c < this.n) {
            output[c] = this.getCol(c);
            ++c;
        }
        c = 0;
        while (c < new_c.length) {
            output[this.n + c] = new_c[c];
            ++c;
        }
        return new Matrix(true, output);
    }

    public Matrix appendRow(Vector ... new_r) {
        Vector[] output = (Vector[])new Object[this.m + new_r.length];
        int r = 0;
        while (r < this.m) {
            output[r] = this.getRow(r);
            ++r;
        }
        r = 0;
        while (r < new_r.length) {
            output[this.n + r] = new_r[r];
            ++r;
        }
        return new Matrix(output);
    }

    public double get(int r, int c) {
        return this.data[r][c];
    }

    public Matrix identity(int size) {
        double[][] data = new double[size][size];
        int i = 0;
        while (i < size) {
            data[i][i] = 1.0;
            ++i;
        }
        Matrix output = new Matrix(data);
        output.ge_form = true;
        output.ge1_form = true;
        output.echelon_form = true;
        return output;
    }

    public boolean eq(Matrix other) {
        boolean output = true;
        int c = 0;
        while (c < this.n) {
            int r = 0;
            while (r < this.m) {
                if (this.data[r][c] != other.data[r][c]) {
                    output = false;
                }
                ++r;
            }
            ++c;
        }
        return output;
    }

    public static void swap(Object[] data, int index_1, int index_2) {
        Object temp = data[index_1];
        data[index_1] = data[index_2];
        data[index_2] = temp;
    }

    public String toString() {
        Vector[] rows;
        String output = "Matrix [Rows: " + this.m + ", Columns: " + this.n + "]\num_columns";
        Vector[] vectorArray = rows = this.rows();
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            Vector r = vectorArray[n2];
            output = String.valueOf(output) + r + '\n';
            ++n2;
        }
        return output;
    }
}

